@props([
    'show' => 'hidden',
])

<div class="fixed z-10 inset-0 overflow-y-auto {{ $show }}">
    <div class="flex items-center justify-center min-h-screen px-4 pt-4 pb-20 text-center sm:block sm:p-0">
        <div class="fixed inset-0 transition-opacity">
            <div class="absolute inset-0 bg-gray-500 opacity-75"></div>
        </div>
        <span class="{{ $show }} sm:inline-block sm:align-middle sm:h-screen">&#8203;</span>
        <div class=" border-t-4 border-orange-400 inline-block align-center bg-white rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-lg sm:w-full" role="dialog" aria-modal="true" aria-labelledby="modal-headline">
            <div class="bg-gray-100 px-2 py-2 text-left">
                {{ $title }}
            </div>
            {{ $body }}
            <div class="bg-gray-200 px-4 py-3 text-right">
                {{ $footer }}
            </div>
        </div>
    </div>
</div>